define([
    'modules/appointments/cancellation/cancellation-control-view',
    'User',
], function (
    CancellationControlView,
    User
) {
    'use strict';

    return CancellationControlView.extend({
        saveCancelledAppointment: function() {

            this.populateCancelDetails();

            return this.model.save({}, {
                url: this.model.get('links').get('self')
                    .get('href'),
                type: 'PUT',
                data: JSON.stringify(this.model.serializeDataToSave()),
                contentType: 'application/json',
                dataType: 'json',
            }).done(function(response) {
                this.model.set('lastUpdatedDate', response.lastUpdatedDate);
            }.bind(this));
        },
        populateCancelDetails: function() {
            var model = this.model;

            // save without attributes link and dataIdentifier
            var CANCEL_DETAIL_CODE = 'DETCODE8';
            var cancelDetailCode = {
                userId: User.get('id'),
                detailCode: {code: CANCEL_DETAIL_CODE},
            };

            // eslint-disable-next-line max-len
            var updatedDetailCodes = model.has('appointmentRequestDetailCode') ? model.get('appointmentRequestDetailCode') : [];
            updatedDetailCodes.unshift(cancelDetailCode);

            model.set({
                status: 'Cancelled',
                appointmentRequestDetailCode: updatedDetailCodes,
            });
        },
    });
});
